﻿
CREATE PROCEDURE [App].[NVCC_usp_UserCounts]
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_UserCounts
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 08-02-2016
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : Various counts of users
--==================================================================================
--Uses: App.NVCC_Users
--Uses: App.NVCC_AccessLog
--Uses: App.vNVCC_ProductionAccessLog
--Uses: App.NVCC_udf_activeUserCount()

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

SELECT *
FROM
	(
		SELECT COUNT(*) AS LookedUsers
		FROM App.NVCC_Users
	) AS T,
	(
		SELECT COUNT(DISTINCT UserID) AS LoggedUsers 
		FROM App.NVCC_AccessLog
	) AS L,
	(
		SELECT COUNT(DISTINCT UserID) AS RDPUsers
		FROM App.vNVCC_ProductionAccessLog
	) AS R,
	(
		SELECT
			SUM(ActiveUsers) AS ActiveUsers,
			COUNT(*) AS ActiveSites
		FROM App.NVCC_udf_ActiveUserCount()
	) AS A

